<?php
/*
 * Simple Demo of Duo's Web SDK
 *
 * Simple login form with hardcoded username/password
 * protected using Duo
 */

include($_SERVER['DOCUMENT_ROOT']."/header.html");

require_once 'src/Web.php';

define('USERNAME', 'demo');
define('PASSWORD', 'letmein');

$config = parse_ini_file("../duo.conf");

define('IKEY', $config['client_id_dmp']);
define('SKEY', $config['client_secret_dmp']);
define('HOST', $config['api_hostname_dmp']);
define('AKEY', $config['akey_dmp']);

/*
 * STEP 3:
 * Once secondary auth has completed you may log in the user
 */
if (isset($_POST['sig_response'])) {
    /*
     * Verify sig response and log in user. Make sure that verifyResponse
     * returns the username we logged in with. You can then set any
     * cookies/session data for that username and complete the login process.
     */
    $resp = Duo\Web::verifyResponse(IKEY, SKEY, AKEY, $_POST['sig_response']);
    //if ($resp === USERNAME) {
        // Password protected content would go here.
        echo 'Primary and secondary authentication successful<br>';
        echo '<a href=\'/dmp/\'>Back to login</a>';
    //}
}

/*
 * STEP 2:
 * verify username and password
 * if the user and pass are good, then generate a sig_request and
 * load up the Duo iframe for secondary authentication
 */
else if (isset($_POST['user']) && isset($_POST['pass'])) {
    //if ($_POST['user'] === USERNAME && $_POST['pass'] === PASSWORD) {
        /*
         * Perform secondary auth, generate sig request, then load up Duo
         * javascript and iframe.
         */
        $sig_request = Duo\Web::signRequest(IKEY, SKEY, AKEY, $_POST['user']);
    ?>
        <script type="text/javascript" src="/dmp/Duo-Web-v2.js"></script>
        <link rel="stylesheet" type="text/css" href="/dmp/Duo-Frame.css">
        <center>
        <div class="inner-wrapper col-sm-12">
        <iframe id="duo_iframe"
            data-host="<?php echo HOST; ?>"
            data-sig-request="<?php echo $sig_request; ?>"
        ></iframe>
      </div>
        </center>
<?php
    //}
}

/*
 * STEP 1: login form
 * handled exactly as usual
 */
else {
    ?>

<div class="container col-xl-10 col-xxl-8 px-4 py-5">
    <div class="row align-items-center g-lg-5 py-5">
      <div class="col-lg-7 text-center text-lg-start">
        <h1 class="display-4 fw-bold lh-1 mb-3">Device Managemnt Portal Login</h1>
        <p class="col-lg-10 fs-4">Built on PHP WebSDK v2. Allows a user to manage their devices.</p>
      </div>
      <div class="col-md-10 mx-auto col-lg-5">
        <form class="p-4 p-md-5 border rounded-3 bg-light" data-bitwarden-watching="1" action="/dmp" method="post">
          <div class="form-floating mb-3">
            <input type="text" class="form-control" id="user" name="user" placeholder="username" autocomplete="off" style="background-image: url(&quot;data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAASCAYAAABSO15qAAAAAXNSR0IArs4c6QAAAPhJREFUOBHlU70KgzAQPlMhEvoQTg6OPoOjT+JWOnRqkUKHgqWP4OQbOPokTk6OTkVULNSLVc62oJmbIdzd95NcuGjX2/3YVI/Ts+t0WLE2ut5xsQ0O+90F6UxFjAI8qNcEGONia08e6MNONYwCS7EQAizLmtGUDEzTBNd1fxsYhjEBnHPQNG3KKTYV34F8ec/zwHEciOMYyrIE3/ehKAqIoggo9inGXKmFXwbyBkmSQJqmUNe15IRhCG3byphitm1/eUzDM4qR0TTNjEixGdAnSi3keS5vSk2UDKqqgizLqB4YzvassiKhGtZ/jDMtLOnHz7TE+yf8BaDZXA509yeBAAAAAElFTkSuQmCC&quot;); background-repeat: no-repeat; background-attachment: scroll; background-size: 16px 18px; background-position: 98% 50%; cursor: auto;">
            <label for="floatingInput">Username</label>
          </div>
          <div class="form-floating mb-3">
            <input type="password" class="form-control" id="pass" name="pass" placeholder="Password" autocomplete="off" style="background-image: url(&quot;data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAASCAYAAABSO15qAAAAAXNSR0IArs4c6QAAAPhJREFUOBHlU70KgzAQPlMhEvoQTg6OPoOjT+JWOnRqkUKHgqWP4OQbOPokTk6OTkVULNSLVc62oJmbIdzd95NcuGjX2/3YVI/Ts+t0WLE2ut5xsQ0O+90F6UxFjAI8qNcEGONia08e6MNONYwCS7EQAizLmtGUDEzTBNd1fxsYhjEBnHPQNG3KKTYV34F8ec/zwHEciOMYyrIE3/ehKAqIoggo9inGXKmFXwbyBkmSQJqmUNe15IRhCG3byphitm1/eUzDM4qR0TTNjEixGdAnSi3keS5vSk2UDKqqgizLqB4YzvassiKhGtZ/jDMtLOnHz7TE+yf8BaDZXA509yeBAAAAAElFTkSuQmCC&quot;); background-repeat: no-repeat; background-attachment: scroll; background-size: 16px 18px; background-position: 98% 50%; cursor: auto;">
            <label for="floatingPassword">Password</label>
          </div>
          <button class="w-100 btn btn-lg btn-outline-success" type="submit">Login</button>
          <br /><br />
        </form>
      </div>
    </div>
  </div>

<?
}
include($_SERVER['DOCUMENT_ROOT']."/footer.html");
?>